from flask import Flask, abort, request
from flask_sqlalchemy import SQLAlchemy
import redis
from linebot import LineBotApi, WebhookHandler
from linebot.exceptions import InvalidSignatureError
from linebot.models import VideoSendMessage, ImageSendMessage, MessageEvent, TextMessage, TextSendMessage
import json
# from models import tables
# from router import reply

from .config.config import config

db = SQLAlchemy()
redis_client = redis.Redis(host=config['development'].REDIS_HOST,
                           port=config['development'].REDIS_PORT,
                           db=config['development'].REDIS_DB)


def create_app(config_name):
    app = Flask(__name__)

    # 設定config
    app.config.from_object(config['development'])
    # redis_client = redis.Redis(host=app.config['REDIS_HOST'],
    #                            port=app.config['REDIS_PORT'],
    #                            db=app.config['REDIS_DB'])
    from .models.tables import Response
    from .router.reply import reply
    db.init_app(app)
    line_bot_api = LineBotApi(app.config['LINE_CHANNEL_ACCESS_TOKEN'])
    handler = WebhookHandler(app.config['LINE_CHANNEL_SECRET'])

    @app.route('/y/callback', methods=['POST', 'GET'])
    def home():

        if request.method == "GET":
            msg = request.args.get('msg')   # 取得網址的 msg 參數

            if msg != None:
                # 如果有 msg 參數，觸發 LINE Message API 的 push_message 方法
                line_bot_api.push_message(
                    app.config['LINE_USER_ID'], TextSendMessage(text=msg))
                return msg
            return 'OK'
        elif request.method == "POST":
            signature = request.headers["X-Line-Signature"]
            body = request.get_data(as_text=True)
            json_data = json.loads(body)
            try:
                handler.handle(body, signature)
                # 取得 reply token
                tk = json_data['events'][0]['replyToken']
                msg = json_data['events'][0]['message']['text']   # 取得使用者發送的訊息
                line_bot_api.reply_message(tk, reply(msg))
                # line_bot_api.reply_message(tk, TextSendMessage(text=msg))
                # line_bot_api.reply_message(tk,text_message)
            except:
                print("error")
            return "OK"

    @app.route('/y')
    def index():
        return 'hello world'

    @app.route('/y/create')
    def create_db():
        db.create_all()
        redis_client.set('light1', int(False))
        redis_client.set('light2', int(False))
        return 'ok'

    @app.route('/y/create_reponse')
    def create_response():
        get = request.args.get('msg')
        responce = request.args.get('responce')
        type = request.args.get('type')
        if get and responce and type:
            u = Response(get, responce, type)
            db.session.add(u)
            db.session.commit()
            return 'ok'
        else:
            return 'error'

    @app.route('/y/get_reponse')
    def get_response():  # from db
        get = request.args.get('msg')
        response = Response.query.filter_by(get=get).first()
        if response:
            return response.responce
        else:
            return 'no response'

    @app.route('/y/work')
    def query():
        temperature = request.args.get('temperature')
        humidity = request.args.get('humidity')
        if temperature:
            redis_client.set("temperature", temperature)
            if float(temperature) > 38:
                if redis_client.get("high_temp") == None:
                    line_bot_api.push_message(app.config['LINE_USER_ID'], reply(
                        "template_temperature:"+str(temperature)))
                    redis_client.set("high_temp", str(1), ex=10)
        if humidity:
            redis_client.set("humidity", humidity)
        # return json with light1 and light2
        light1 = "on" if int(redis_client.get("light1")) == 1 else "off"
        light2 = "on" if int(redis_client.get("light2")) == 1 else "off"
        return json.dumps({"light1": light1, "light2": light2})

    @app.route('/y/warning')
    def warning():
        gas_sensor = request.args.get('gas_sensor')
        PIR_t = request.args.get('PIR')
        template = request.args.get('template')
        if gas_sensor:
            line_bot_api.push_message(app.config['LINE_USER_ID'], reply(
                "template_gas:"+str(gas_sensor)))
        if PIR_t:
            line_bot_api.push_message(app.config['LINE_USER_ID'], reply(
                "template_PIR"+str(template)+":"+str(PIR_t)))
        return 'ok'
        # template_PIR1:靠近 2:很近 3:臉上

    @app.route('/y/falldown')
    def falldown():
        line_bot_api.push_message(app.config['LINE_USER_ID'], reply("跌倒了"))
        return 'ok'

    # @app.route('/max')
    # def insert_max():
    #     u = Person('Max')
    #     db.session.add(u)
    #     db.session.commit()
    #     return 'ok'

    @app.route('/y/redis')
    def redis_test():
        redis_client.set('example_key', 'Hello, Redis!')
        value = redis_client.get('example_key')
        return f"Value from Redis: {value.decode('utf-8')}"

    return app
